<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Tip extends Model {
    protected $fillable = [
        'description'
    ];

    public function translations() {
        return $this->hasMany(TipTranslation::class);
    }

    public function scopeSearch($query, $search) {
        $search = "%" . $search . "%";
        return $query->where(function ($q) use ($search) {
            $q->orWhere('description', 'LIKE', $search)
                ->orWhereHas('translations', function ($q) use ($search) {
                    $q->where('description', 'LIKE', $search);
                });
        });
    }
}
