<?php

namespace Database\Seeders;

use App\Models\Language;
use App\Models\Setting;
use App\Models\User;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Hash;
use Spatie\Permission\Models\Role;

class InstallationSeeder extends Seeder {
    public function run() {
        //        $this->call([
        //            InstallationSeeder::class,
        //        ]);

        Role::updateOrCreate(['name' => 'User']);
        Role::updateOrCreate(['name' => 'Super Admin']);

        $user = User::updateOrCreate(['id' => 1], [
            'id'       => 1,
            'name'     => 'admin',
            'email'    => 'admin@gmail.com',
            'password' => Hash::make('admin123'),
        ]);
        $user->syncRoles('Super Admin');
        Language::updateOrInsert(
            ['id' => 1],
            [
                'name'       => 'English',
                'code'       => 'en',
                'app_file'   => 'en.json',
                'panel_file' => 'en.json',
                'image'      => 'language/en.svg'
            ]
        );
        Setting::upsert([
		['name' => 'pinterest_link', 'value' => '', 'type' => 'string'],
		['name' => 'linkedin_link', 'value' => '', 'type' => 'string'],
		['name' => 'facebook_link', 'value' => '', 'type' => 'string'],
		['name' => 'x_link', 'value' => '', 'type' => 'string'],
		['name' => 'instagram_link', 'value' => '', 'type' => 'string'],
		['name' => 'google_map_iframe_link', 'value' => '', 'type' => 'string'],
		['name' => 'app_store_link', 'value' => '', 'type' => 'string'],
		['name' => 'play_store_link', 'value' => '', 'type' => 'string'],

		['name' => 'footer_description', 'value' => '', 'type' => 'string'],
		['name' => 'web_theme_color', 'value' => '#00B2CA', 'type' => 'string'],
		['name' => 'firebase_project_id', 'value' => '', 'type' => 'string'],
		['name' => 'company_address', 'value' => '', 'type' => 'string'],
		['name' => 'gecode_xyz_api_key', 'value' => '', 'type' => 'string'],
		['name' => 'placeholder_image', 'value' => 'assets/images/logo/favicon.png', 'type' => 'file'],
		['name' => 'web_logo', 'value' => 'assets/images/logo/sidebar_logo.png', 'type' => 'file'],
        ], ['name'], ['value', 'type']);
    }
}
