<?php

use App\Models\Blog;
use App\Models\Category;
use App\Models\FeatureSection;
use App\Models\Item;
use App\Models\User;
use App\Models\UserFcmToken;
use App\Services\HelperService;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Category::chunk(100, static function ($categories) {
            foreach ($categories as $category) {
                $category->update([
                    'slug' => HelperService::generateUniqueSlug(new Category(), $category->name, $category->id)
                ]);
            }
        });

        Schema::table('categories', static function (Blueprint $table) {
            $table->unique('slug');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('categories', static function (Blueprint $table) {
            $table->dropUnique('slug');
        });
    }
};
