@extends($activeTemplate . 'layouts.app')
@section('app')
    @php
        $maintenance = getContent('maintenance.data', true);
    @endphp
    <div class="maintenance-page flex-column justify-content-center">
        <div class="container">
            <div class="row justify-content-center align-items-center">
                <div class="col-lg-8 text-center">
                    <div class="row justify-content-center">
                        <div class="col-sm-6 col-8 col-lg-12">
                            <img src="{{ getImage('assets/images/maintenance/' . @$maintenance->data_values->image) }}" alt="@lang('image')" class="img-fluid mx-auto mb-5">
                        </div>
                    </div>
                    <p class="mb-4">
                        @php echo $maintenance->data_values->description @endphp
                    </p>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('style')
    <style>
        .maintenance-page {
            display: grid;
            place-content: center;
            width: 100vw;
            height: 100vh;
        }

        .maintenance-icon {
            width: 60px;
            height: 60px;
            display: grid;
            place-items: center;
            aspect-ratio: 1;
            border-radius: 50%;
            background: #fff;
            font-size: 26px;
            color: #e73d3e;
        }
    </style>
@endpush
