@php
    $headerContent = getContent('contact_us.content', true);
@endphp

<div class="header-top bg--base">
    <div class="container">
        <div class="header__top__wrapper">
            <ul class="contact-list">
                <li>
                    <span class="name text--white">@lang('Email: ')</span>
                    <a
                       href="mailto:{{ __(@$headerContent->data_values->contact_email) }}">{{ __(@$headerContent->data_values->contact_email) }}</a>
                </li>
                <li>
                    <span class="name text--white">@lang('Phone: ')</span>
                    <a
                       href="tel:{{ __(@$headerContent->data_values->contact_number) }}">{{ __(@$headerContent->data_values->contact_number) }}</a>
                </li>
            </ul>

            @if (gs('multi_language'))
                @php
                    $language = App\Models\Language::all();
                    $selectedLang = $language->where('code', session('lang') ?? 'en')->first();
                @endphp

                <div class="language dropdown">
                    <button class="language-wrapper" data-bs-toggle="dropdown" aria-expanded="false">
                        <div class="language-content">
                            <div class="language_flag">
                                <img src="{{ getImage(getFilePath('language') . '/' . @$selectedLang->image, getFileSize('language')) }}"
                                     alt="flag">
                            </div>
                            <p class="language_text_select">{{ __(@$selectedLang->name) }}</p>
                        </div>
                        <span class="collapse-icon"><i class="las la-angle-down"></i></span>
                    </button>
                    <div class="dropdown-menu langList_dropdow py-2">
                        <ul class="langList">
                            @foreach ($language as $item)
                                <li class="language-list langSel" data-code="{{ $item->code }}">
                                    <div class="language_flag">
                                        <img src="{{ getImage(getFilePath('language') . '/' . $item->image, getFileSize('language')) }}"
                                             alt="flag">
                                    </div>
                                    <p class="language_text">{{ $item->name }}</p>
                                </li>
                            @endforeach
                        </ul>
                    </div>
                </div>
            @endif
        </div>
    </div>
</div>
