<?php $__env->startSection('title'); ?>
    <?php echo e(__("Edit Blogs")); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('page-title'); ?>
    <div class="page-title">
        <div class="row">
            <div class="col-12 col-md-6 order-md-1 order-last">
                <h4><?php echo $__env->yieldContent('title'); ?></h4>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <section class="section">
        <div class="buttons">
            <a class="btn btn-primary" href="<?php echo e(route('blog.index')); ?>">< <?php echo e(__("Back to All Blogs")); ?> </a>
        </div>
        <div class="row">
            <form action="<?php echo e(route('blog.update', $blog->id)); ?>" method="POST" data-parsley-validate enctype="multipart/form-data">
                <?php echo method_field('PUT'); ?>
                <?php echo csrf_field(); ?>
                <input type="hidden" name="edit_data" value=<?php echo e($blog->id); ?>>
                <div class="col-md-12">
                    <div class="card">
                        <div class="card-header"><?php echo e(__("Edit Blogs")); ?></div>
                        <div class="card-body mt-3">
                            <div class="row">
                                <div class="col-md-6 col-12">
                                    <div class="form-group mandatory">
                                        <label for="title" class="mandatory form-label"><?php echo e(__('Title')); ?></label>
                                        <input type="text" name="title" id="title" class="form-control" data-parsley-required="true" value="<?php echo e($blog->title); ?>">
                                    </div>
                                </div>
                                <div class="col-md-6 col-12">
                                    <div class="form-group mandatory">
                                        <label for="slug" class="form-label"><?php echo e(__('Slug')); ?> <small>(English Only)</small></label>
                                        <input type="text" name="slug" id="slug" class="form-control" data-parsley-required="true" value="<?php echo e($blog->slug); ?>">
                                    </div>
                                </div>

                                <div class="col-md-6 col-12">
                                    <div class="form-group mandatory">
                                        <label for="Field Name" class="mandatory form-label"><?php echo e(__('Image')); ?></label>
                                        <div class="cs_field_img ">
                                            <input type="file" name="image" class="image" style="display: none" accept=" .jpg, .jpeg, .png, .svg">
                                            <img src="<?php echo e(empty($blog->image) ? asset('assets/img_placeholder.jpeg') : $blog->image); ?>" alt="" class="img preview-image" id="">
                                            <div class='img_input'><?php echo e(__("Browse File")); ?></div>
                                        </div>
                                        <div class="input_hint"> <?php echo e(__("Icon (use 256 x 256 size for better view)")); ?></div>
                                        <div class="img_error" style="color:#DC3545;"></div>
                                    </div>
                                </div>
                                <div class="col-md-12 col-12">
                                    <div class="form-group mandatory">
                                        <label for="tags" class="mandatory form-label"><?php echo e(__('Tags')); ?></label>
                                        <select id="tags" name="tags[]" data-tags="true" data-placeholder="<?php echo e(__("Tags")); ?>" data-allow-clear="true" class="select2 col-12 w-100" multiple="multiple" data-parsley-required="true">
                                            <?php $__currentLoopData = $blog->tags; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tag): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($tag); ?>" selected><?php echo e($tag); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>
                                </div>

                                <div class="col-md-12 col-12">
                                    <label for="tinymce_editor" class="mandatory form-label"><?php echo e(__('Description')); ?></label>
                                    <textarea name="description" id="tinymce_editor" class="form-control" cols="10" rows="4"><?php echo e($blog->description); ?></textarea>
                                </div>

                            </div>
                        </div>
                    </div>
                    <div class="col-md-12 text-end">
                        <input type="submit" class="btn btn-primary" value="<?php echo e(__("Save and Back")); ?>">
                    </div>
                </div>
            </form>
        </div>
    </section>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('js'); ?>
    <script !src="">
        $('#category_id').val("<?php echo e($blog->category_id); ?>")
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /opt/lampp/htdocs/eClassify/resources/views/blog/edit.blade.php ENDPATH**/ ?>