<?php $__env->startSection('title'); ?>
    <?php echo e(__("Edit Categories")); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('page-title'); ?>
    <div class="page-title">
        <div class="row">
            <div class="col-12 col-md-6 order-md-1 order-last">
                <h4><?php echo $__env->yieldContent('title'); ?></h4>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <section class="section">
        <div class="buttons">
            <a class="btn btn-primary" href="<?php echo e(route('category.index')); ?>">< <?php echo e(__("Back to All Categories")); ?> </a>
        </div>
        <div class="row">
            <form action="<?php echo e(route('category.update', $category_data->id)); ?>" method="POST" data-parsley-validate enctype="multipart/form-data">
                <?php echo method_field('PUT'); ?>
                <?php echo csrf_field(); ?>
                <input type="hidden" name="edit_data" value=<?php echo e($category_data->id); ?>>
                <div class="col-md-12">
                    <div class="card">
                        <div class="card-header"><?php echo e(__("Edit Categories")); ?></div>
                        <div class="card-body mt-3">
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="col-md-12 form-group mandatory">
                                        <label for="name" class="mandatory form-label"><?php echo e(__('Name')); ?></label>
                                        <input type="text" name="name" id="name" class="form-control" data-parsley-required="true" value="<?php echo e($category_data->name); ?>">
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="col-md-12 form-group mandatory">
                                        <label for="p_category" class="mandatory form-label"><?php echo e(__('Parent Category')); ?></label>
                                        <select name="selected_category" class="form-select form-control" id="p_category" data-placeholder="<?php echo e(__("Select Category")); ?>">
                                            <option value="<?php echo e($parent_category); ?>" disabled id="default_opt" selected><?php echo e($parent_category == '' ? 'Root' : $parent_category); ?></option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-12">
                                    <div class="col-md-12 form-group mandatory">
                                        <label for="slug" class="form-label"><?php echo e(__('Slug')); ?> <small>(English Only)</small></label>
                                        <input type="text" name="slug" id="slug" class="form-control" data-parsley-required="true" value="<?php echo e($category_data->slug); ?>">
                                    </div>
                                </div>

                                <div class="col-md-6">
                                    <label for="description" class="mandatory form-label"><?php echo e(__('Description')); ?></label>
                                    <textarea name="description" id="description" class="form-control" cols="10" rows="5"><?php echo e($category_data->description); ?></textarea>
                                    <div class="form-check form-switch mt-3">
                                        <input type="hidden" name="status" id="status" value="<?php echo e($category_data->status); ?>">
                                        <input class="form-check-input status-switch" type="checkbox" role="switch" aria-label="status" name="active" id="required" <?php echo e($category_data->status == 1 ? 'checked' : ''); ?>><?php echo e(__('Active')); ?>

                                        <label class="form-check-label" for="status"></label>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="col-md-12 form-group mandatory">
                                        <label for="Field Name" class="mandatory form-label"><?php echo e(__('Image')); ?></label>
                                        <div class="cs_field_img ">
                                            <input type="file" name="image" class="image" style="display: none" accept=" .jpg, .jpeg, .png, .svg">
                                            <img src="<?php echo e(empty($category_data->image) ? asset('assets/img_placeholder.jpeg') : $category_data->image); ?>" alt="" class="img preview-image" id="">
                                            <div class='img_input'><?php echo e(__("Browse File")); ?></div>
                                        </div>
                                        <div class="input_hint"> <?php echo e(__("Icon (use 256 x 256 size for better view)")); ?></div>
                                        <div class="img_error" style="color:#DC3545;"></div>
                                    </div>
                                </div>


                                <?php $__currentLoopData = $languages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$language): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <hr>
                                    <h5><?php echo e(__("Translation")); ?></h5>
                                    <div class="row">

                                        <hr>
                                        <h5><?php echo e(($key+1).". ".$language->name); ?></h5>
                                        <div class="col-md-12 form-group">
                                            <label for="name" class="form-label"><?php echo e(__('Name')); ?> : </label>
                                            <input name="translations[<?php echo e($language->id); ?>]" id="name" class="form-control" value="<?php echo e($translations[$language->id] ?? ''); ?>" required>
                                        </div>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-12 text-end">
                        <input type="submit" class="btn btn-primary" value="<?php echo e(__("Save and Back")); ?>">
                    </div>
                </div>
            </form>
        </div>
    </section>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /opt/lampp/htdocs/eClassify/resources/views/category/edit.blade.php ENDPATH**/ ?>