<?php $__env->startSection('title'); ?>
    <?php echo e(__("Create Blogs")); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('page-title'); ?>
    <div class="page-title">
        <div class="row">
            <div class="col-12 col-md-6 order-md-1 order-last">
                <h4><?php echo $__env->yieldContent('title'); ?></h4>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <section class="section">
        <div class="buttons">
            <a class="btn btn-primary" href="<?php echo e(route('blog.index')); ?>">< <?php echo e(__("Back to Blogs")); ?> </a>
        </div>
        <div class="row">
            <form action="<?php echo e(route('blog.store')); ?>" class="form-redirection" method="POST" data-parsley-validate enctype="multipart/form-data">
                <?php echo csrf_field(); ?>
                <div class="card">
                    <div class="card-header"><?php echo e(__("Add Blog")); ?></div>
                    <div class="card-body mt-3">
                        <div class="row">
                            <div class="col-md-6 col-12">
                                <div class="form-group mandatory">
                                    <label for="title" class="mandatory form-label"><?php echo e(__('Title')); ?></label>
                                    <input type="text" name="title" id="title" class="form-control" data-parsley-required="true">
                                </div>
                            </div>
                            <div class="col-md-6 col-12">
                                <div class="form-group mandatory">
                                    <label for="slug" class="form-label"><?php echo e(__('Slug')); ?> <small>(English Only)</small></label>
                                    <input type="text" name="slug" id="slug" class="form-control" data-parsley-required="true">
                                </div>
                            </div>
                            <div class="col-md-6 col-12">
                                <div class="form-group mandatory">
                                    <label for="Field Name" class="mandatory form-label"><?php echo e(__('Image')); ?></label>
                                    <input type="file" name="image" id="image" class="form-control" data-parsley-required="true" accept=".jpg,.jpeg,.png">
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group mandatory">
                                    <label for="tags" class="mandatory form-label"><?php echo e(__('Tags')); ?></label>
                                    <select id="tags" name="tags[]" data-tags="true" data-placeholder="<?php echo e(__("Tags")); ?>" data-allow-clear="true" class="select2 col-12 w-100" multiple="multiple" data-parsley-required="true" required></select>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-12 col-12">
                            <label for="tinymce_editor" class="mandatory form-label"><?php echo e(__('Description')); ?></label>
                            <textarea name="description" id="tinymce_editor" class="form-control" cols="10" rows="5"></textarea>
                        </div>

                    </div>
                </div>
                <div class="col-md-12 text-end">
                    <input type="submit" class="btn btn-primary" value="<?php echo e(__("Save and Back")); ?>">
                </div>
            </form>
        </div>
    </section>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /opt/lampp/htdocs/eClassify/resources/views/blog/create.blade.php ENDPATH**/ ?>