<?php $__env->startSection('panel'); ?>

    <div class="row">

        <div class="col-lg-12">
            <div class="card b-radius--10 ">
                <div class="card-body p-0">
                    <div class="table-responsive--md  table-responsive">
                        <table class="table table--light style--two">
                            <thead>
                                <tr>
                                    <th><?php echo app('translator')->get('SL'); ?></th>
                                    <th><?php echo app('translator')->get('Time'); ?></th>
                                    <th><?php echo app('translator')->get('Order ID'); ?> | <?php echo app('translator')->get('User'); ?></th>
                                    <th><?php echo app('translator')->get('Product'); ?></th>
                                    <th><?php echo app('translator')->get('Qty'); ?></th>
                                    <th><?php echo app('translator')->get('Amount'); ?></th>
                                    <th><?php echo app('translator')->get('Payment'); ?></th>
                                    <th><?php echo app('translator')->get('Order Status'); ?></th>
                                    <th><?php echo app('translator')->get('Action'); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                            <?php $__empty_1 = true; $__currentLoopData = $orders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <td data-label="<?php echo app('translator')->get('SL'); ?>">
                                    <?php echo e($orders->firstItem() + $loop->index); ?>

                                </td>

                                <td class="date" data-label="<?php echo app('translator')->get('Order Date'); ?>">
                                    <div>
                                        <?php echo e(showDateTime($order->created_at,'d M, Y')); ?>

                                    </div>

                                    <?php echo e(showDateTime($order->created_at,'h:i A')); ?>

                                </td>

                                <td class="trx-id" data-label="<?php echo app('translator')->get('Order ID'); ?> | <?php echo app('translator')->get('User'); ?>">
                                    <div><?php echo e($order->order_track); ?></div>
                                    <a target="_blank" href="<?php echo e(route('admin.users.detail',$order->user_id)); ?>" ><?php echo e(@$order->user->username); ?></a>
                                </td>

                                <td  data-label="<?php echo app('translator')->get('Product Name'); ?>">
                                    <a target="_blank" href="<?php echo e(route('product.details',[$order->product->id,$order->product->slug])); ?>">
                                    <?php echo e(shortDescription(@$order->product->name,20)); ?>(<?php echo e($order->product->sku); ?>)</a>
                                </td>

                                <td class="amount" data-label="<?php echo app('translator')->get('Qty'); ?>">
                                    <span class="badge badge--primary font-weight-bold"><?php echo e($order->qty); ?></span>
                                </td>

                                <td class="amount" data-label="<?php echo app('translator')->get('Total Amount/Qty'); ?>">
                                    <?php echo e($general->cur_sym); ?><?php echo e(getAmount($order->total_amount)); ?>

                                </td>

                                <td data-label="<?php echo app('translator')->get('Payment'); ?>">
                                    <?php if($order->payment_type == 1): ?>

                                        <span data-toggle="tooltip" title="<?php echo app('translator')->get('Direct Payment'); ?>"><?php echo app('translator')->get('DP'); ?></span>
                                    <?php else: ?>
                                    <span data-toggle="tooltip" title="<?php echo app('translator')->get('Cash On Delivery'); ?>"><?php echo app('translator')->get('COD'); ?></span>
                                    <?php endif; ?>
                                </td>

                                <td  data-label="<?php echo app('translator')->get('Order Status'); ?>">
                                    <?php if($order->status == 0): ?>
                                        <span class="badge badge--warning"><?php echo app('translator')->get('Pending'); ?></span>
                                    <?php elseif($order->status == 1): ?>
                                        <span class="badge badge--success"><?php echo app('translator')->get('Delivered'); ?></span>
                                    <?php elseif($order->status == 2): ?>
                                        <span class="badge badge--primary"><?php echo app('translator')->get('Processing'); ?></span>
                                    <?php elseif($order->status == 3): ?>
                                        <span class="badge badge--danger"><?php echo app('translator')->get('Cancelled'); ?></span>
                                    <?php endif; ?>
                                </td>


                                <td data-label="<?php echo app('translator')->get('Action'); ?>">

                                    <a href="<?php echo e(route('admin.orders.details',$order->id)); ?>" class="icon-btn" data-toggle="tooltip" title="" data-original-title="<?php echo app('translator')->get('Order Details'); ?>">
                                        <i class="las la-desktop text--shadow"></i>
                                    </a>

                                    <?php if($order->status == 0): ?>
                                        <button data-route="<?php echo e(route('admin.order.process',$order->id)); ?>" class="icon-btn btn--info ml-1 process" data-toggle="tooltip" data-original-title="<?php echo app('translator')->get('Mark as Processing'); ?>">
                                            <i class="las la-spinner"></i>
                                        </button>
                                    <?php elseif($order->status == 2): ?>
                                        <button data-route="<?php echo e(route('admin.order.deliver',$order->id)); ?>" class="icon-btn btn--success delivered  ml-1" data-toggle="tooltip"  data-original-title="<?php echo app('translator')->get('Mark as Delivered'); ?>">
                                            <i class="lar la-check-circle"></i>
                                        </button>
                                    <?php else: ?>
                                        <button class="icon-btn btn--success  ml-1 disabled">
                                            <i class="lar la-check-circle"></i>
                                        </button>
                                    <?php endif; ?>

                                    <?php if($order->status == 0 && $order->pay_status == 0): ?>
                                        <button type="button" class="icon-btn bg--danger ml-1 cancel"  data-toggle="tooltip" title="<?php echo app('translator')->get('Cancel Order'); ?>" data-id="<?php echo e($order->id); ?>" data-route="<?php echo e(route('admin.order.cancel')); ?>"><i class="las la-ban"></i>
                                        </button>
                                    <?php else: ?>
                                        <button type="button" class="icon-btn bg--danger ml-1" disabled data-toggle="tooltip" data-id="<?php echo e($order->id); ?>" data-route="<?php echo e(route('admin.order.cancel')); ?>"><i class="las la-ban"></i>
                                    <?php endif; ?>
                                </td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td class="text-muted text-center" colspan="100%"><?php echo app('translator')->get('No order found'); ?></td>
                                </tr>
                            <?php endif; ?>

                            </tbody>
                        </table><!-- table end -->
                    </div>
                </div>
                <div class="card-footer py-4">
                    <?php echo e(paginateLinks($orders)); ?>

                </div>
            </div><!-- card end -->
        </div>


    </div>
    
    <div class="modal fade" id="cancelModal" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <form action="" method="POST">
                    <?php echo csrf_field(); ?>
                    <input type="hidden" name="id">
                    <div class="modal-body">
                        <div class="text-center">
                            <i class="las la-exclamation-circle text--danger display-2 mb-15"></i>
                        </div>
                        <h4 class="text--dark mb-15"><?php echo app('translator')->get('Are you sure to cancel this order?'); ?></h4>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn--dark" data-dismiss="modal"><?php echo app('translator')->get('No'); ?></button>
                        <button type="submit"  class="btn btn--danger  del"><?php echo app('translator')->get('Yes'); ?></button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    
    <div class="modal fade" id="processModal" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <form action="" method="POST">
                    <?php echo csrf_field(); ?>
                    <div class="modal-body">
                        <div class="text-center">
                            <i class="las la-exclamation-circle text--danger display-2 mb-15"></i>
                        </div>
                        <h4 class="text--dark mb-15"><?php echo app('translator')->get('Are you sure to mark this as processing?'); ?></h4>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn--dark" data-dismiss="modal"><?php echo app('translator')->get('No'); ?></button>
                        <button type="submit"  class="btn btn--info del"><?php echo app('translator')->get('Yes'); ?></button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    
    <div class="modal fade" id="deliveredModal" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <form action="" method="POST">
                    <?php echo csrf_field(); ?>
                    <div class="modal-body">
                        <div class="text-center">
                            <i class="las la-exclamation-circle text--danger display-2 mb-15"></i>
                        </div>

                        <h4 class="text--dark mb-15"><?php echo app('translator')->get('Are you sure this order has been delivered?'); ?></h4>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn--dark" data-dismiss="modal"><?php echo app('translator')->get('No'); ?></button>
                        <button type="submit"  class="btn btn--success del"><?php echo app('translator')->get('Yes'); ?></button>
                    </div>
                </form>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>



<?php $__env->startPush('breadcrumb-plugins'); ?>
    <form action="" method="GET" class="form-inline float-sm-right bg--white">
        <div class="input-group has_append">
            <input type="text" name="search" class="form-control" placeholder="<?php echo app('translator')->get('Order ID'); ?>" value="<?php echo e($search ?? ''); ?>" autocomplete="off">
            <div class="input-group-append">
                <button class="btn btn--primary" type="submit"><i class="fa fa-search"></i></button>
            </div>
        </div>
    </form>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('style'); ?>
    <style>
        .cancel{
            cursor: pointer;
        }
    </style>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('script'); ?>
     <script>
            'use strict';
            (function ($) {
                $('.cancel').on('click',function(){
                    var route = $(this).data('route')
                    var modal = $('#cancelModal');
                    modal.find('input[name=id]').val($(this).data('id'))
                    modal.find('form').attr('action',route)
                    modal.modal('show');
                })
                $('.process').on('click',function(){
                    var route = $(this).data('route')
                    var modal = $('#processModal');
                    modal.find('form').attr('action',route)
                    modal.modal('show');
                })
                $('.delivered').on('click',function(){
                    var route = $(this).data('route')
                    var modal = $('#deliveredModal');
                    modal.find('form').attr('action',route)
                    modal.modal('show');
                })
            })(jQuery);
     </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/fkyiliss/evangel-ace.com.ng/core/resources/views/admin/orders/all.blade.php ENDPATH**/ ?>