<?php $__env->startSection('panel'); ?>
    <div class="row">
        <div class="col-lg-12">
            <div class="card b-radius--10 ">
                <div class="card-body p-0">
                    <div class="table-responsive--md  table-responsive">
                        <table class="table table--light style--two">
                            <thead>
                            <tr>
                                <th><?php echo app('translator')->get('SL'); ?></th>
                                <th><?php echo app('translator')->get('Name'); ?></th>
                                <th><?php echo app('translator')->get('Category | Brand'); ?></th>
                                <th><?php echo app('translator')->get('Price | Discount'); ?></th>
                                <th><?php echo app('translator')->get('Final Price'); ?></th>
                                <th><?php echo app('translator')->get('Stock | SKU'); ?></th>
                                <th><?php echo app('translator')->get('Sold'); ?></th>
                                <th><?php echo app('translator')->get('Status'); ?></th>
                                <th><?php echo app('translator')->get('Action'); ?></th>
                            </tr>
                            </thead>
                            <tbody>
                            <?php $__empty_1 = true; $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr>
                                <td data-label="<?php echo app('translator')->get('SL'); ?>">
                                    <?php echo e($products->firstItem() + $loop->index); ?>

                                </td>

                                <td data-label="<?php echo app('translator')->get('Name'); ?>" class="text-left">
                                    <?php if($product->featured): ?>
                                    <h3 class="text--success fw-bold d-inline" data-toggle="tooltip" title="<?php echo app('translator')->get('Featured'); ?>">&#9679;</h3>
                                    <?php endif; ?>
                                    <span class="font-weight-bold"><?php echo e(shortDescription($product->name, 30)); ?></span>
                                </td>

                                <td data-label="<?php echo app('translator')->get('Category | Brand'); ?>">
                                    <div><?php echo e(__($product->category->name)); ?></div>
                                    <strong><?php echo e(__($product->brand->name)); ?></strong>
                                </td>
                                <td data-label="<?php echo app('translator')->get('Amount'); ?>">

                                    <?php echo e($general->cur_sym); ?><?php echo e(showAmount($product->price)); ?>

                                    <div class="font-weight-bold">
                                        <?php echo e(getAmount($product->discount, 2)); ?><?php echo app('translator')->get('%'); ?>
                                    </div>

                                </td>

                                <td data-label="<?php echo app('translator')->get('Final Price'); ?>">
                                    <?php
                                        $discount = $product->hot_deal == 1 ? $general->hot_deal_discount :  $product->discount;
                                    ?>
                                    <span class="font-weight-bold"><?php echo e($general->cur_sym); ?><?php echo e(afterDiscount($product->price,  $discount)); ?></span>
                                </td>
                                <td data-label="<?php echo app('translator')->get('Stock'); ?>">
                                    <div class="font-weight-bold"><?php echo e($product->stock != 0 ? $product->stock : 'Stock Out'); ?></div>
                                    <?php echo e($product->sku); ?>


                                </td>

                                <td data-label="<?php echo app('translator')->get('Sold'); ?>">
                                    <?php echo e($product->sold); ?> <?php echo app('translator')->get('Pcs'); ?>
                                </td>

                                <td data-label="<?php echo app('translator')->get('Status'); ?>">
                                    <?php if($product->status == 0): ?>
                                        <span class="badge badge--danger"><?php echo app('translator')->get('Disabled'); ?></span>
                                    <?php else: ?>
                                        <span class="badge badge--success"><?php echo app('translator')->get('Enabled'); ?></span>
                                    <?php endif; ?>
                                </td>

                                <td data-label="<?php echo app('translator')->get('Action'); ?>">
                                    <a href="<?php echo e(route('admin.product.image.page', $product->id)); ?>" class="icon-btn btn--dark ml-1" data-toggle="tooltip"  data-original-title="<?php echo app('translator')->get('Images'); ?>">
                                        <i class="las la-image text--shadow"></i>
                                    </a>



                                    <?php if($product->hot_deal == 0): ?>
                                        <button data-route="<?php echo e(route('admin.product.hot.deal', $product->id)); ?>" class="icon-btn btn--info hot-deal ml-1" data-toggle="tooltip"  data-original-title="<?php echo app('translator')->get('Add as hot deal'); ?>">
                                            <i class="las la-fire-alt"></i>
                                        </button>
                                    <?php else: ?>
                                        <button data-route="<?php echo e(route('admin.product.hot.deal', $product->id)); ?>" class="icon-btn btn--danger remove-hot-deal ml-1" data-toggle="tooltip"  data-original-title="<?php echo app('translator')->get('Remove from hot deals'); ?>">
                                            <i class="las la-fire-alt"></i>
                                        </button>
                                    <?php endif; ?>

                                    <a href="<?php echo e(route('admin.product.update.page', $product->id)); ?>" class="icon-btn ml-1" data-toggle="tooltip"  data-original-title="<?php echo app('translator')->get('Edit'); ?>">
                                        <i class="la la-pencil-alt text--shadow"></i>
                                    </a>
                                </td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td class="text-muted text-center" colspan="100%"><?php echo e(__($emptyMessage)); ?>!</td>
                                </tr>
                            <?php endif; ?>
                            </tbody>
                        </table><!-- table end -->
                    </div>
                </div>
                <div class="card-footer py-4">
                    <?php echo e(paginateLinks($products)); ?>

                </div>
            </div>
        </div>

    </div>

 <div class="modal fade" id="hotdealModal" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
        <button type="button" class="close ml-auto m-3" data-dismiss="modal" aria-label="Close">
        <span aria-hidden="true">&times;</span>
        </button>
            <form action="" method="POST">
                <?php echo csrf_field(); ?>
                <div class="modal-body text-center">

                    <i class="las la-exclamation-circle text--info display-2 mb-15"></i>

                    <h5 class="text--secondary mb-15"><?php echo app('translator')->get('Are you sure want to add this product as hot deal?'); ?></h5>

                </div>
            <div class="modal-footer">
                <button type="button" class="btn btn--dark" data-dismiss="modal"><?php echo app('translator')->get('No'); ?></button>
                <button type="submit"  class="btn btn--info del"><?php echo app('translator')->get('Yes'); ?></button>
            </div>

            </form>
        </div>
    </div>
</div>

 <div class="modal fade" id="removedealModal" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
        <button type="button" class="close ml-auto m-3" data-dismiss="modal" aria-label="Close">
        <span aria-hidden="true">&times;</span>
        </button>
            <form action="" method="POST">
                <?php echo csrf_field(); ?>
                <div class="modal-body text-center">

                    <i class="las la-exclamation-circle text--danger display-2 mb-15"></i>
                    <h6 class="text--secondary mb-15"><?php echo app('translator')->get('Are you sure want to remove this product from hot deal?'); ?></h6>

                </div>
            <div class="modal-footer">
                <button type="button" class="btn btn--dark" data-dismiss="modal"><?php echo app('translator')->get('No'); ?></button>
                <button type="submit"  class="btn btn--danger del"><?php echo app('translator')->get('Yes'); ?></button>
            </div>

            </form>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>



<?php $__env->startPush('breadcrumb-plugins'); ?>
<div class="d-flex flex-wrap justify-content-sm-end">

    <form action="" method="GET" class="form-inline float-sm-right bg--white mt-2 mr-2">
        <div class="input-group has_append">
            <input type="text" name="search" class="form-control" placeholder="<?php echo app('translator')->get('Name / SKU'); ?>" value="<?php echo e(request('search')); ?>">
            <div class="input-group-append">
                <button class="btn btn--primary" type="submit"><i class="fa fa-search"></i></button>
            </div>
        </div>
    </form>

    <a href="<?php echo e(route('admin.product.add.page')); ?>" class="btn btn-sm btn--primary box--shadow1 text--small d-inline-flex justify-content-center align-items-center mt-2">
        <i class="la la-fw la-plus"></i><?php echo app('translator')->get('Add New'); ?>
    </a>
</div>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('script'); ?>
    <script>
        'use strict';
        $('.hot-deal').on('click',function(){
            var route = $(this).data('route')
            var modal = $('#hotdealModal');
            modal.find('form').attr('action',route)
            modal.modal('show');
        })
        $('.remove-hot-deal').on('click',function(){
            var route = $(this).data('route')
            var modal = $('#removedealModal');
            modal.find('form').attr('action',route)
            modal.modal('show');
        })
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/fkyiliss/evangel-ace.com.ng/core/resources/views/admin/product/index.blade.php ENDPATH**/ ?>