<?php
    $contact = getContent('contact_us.content', true);

?>
<?php $__env->startSection('content'); ?>
<!-- Contact Section Starts Here -->
<section class="contact-section pt-50 pb-50">
    <div class="row gy-4">
        <div class="col-lg-7">
            <div class="contact-form-wrapper" method="post" action="">
                <h4 class="title"><?php echo e(__(@$contact->data_values->heading)); ?></h4>
                <form class="contact-form" method="post" action="">
                    <?php echo csrf_field(); ?>
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form--group">
                                <input name="name" type="text" class="form--control" value="<?php echo e(Auth::user() ? auth()->user()->fullname : old('name')); ?>" placeholder="<?php echo app('translator')->get('Name'); ?>" <?php echo e(Auth::user() ? 'readonly' : 'required'); ?>>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form--group">
                                <input name="email" type="email" class="form--control" value="<?php echo e(Auth::user() ? auth()->user()->email : old('email')); ?>" placeholder="<?php echo app('translator')->get('Email'); ?>" <?php echo e(Auth::user() ? 'readonly' : 'required'); ?>>
                            </div>
                        </div>
                    </div>
                    <div class="form--group">
                        <input name="subject" type="text" placeholder="<?php echo app('translator')->get('Write your subject'); ?>" class="form--control" value="<?php echo e(old('subject')); ?>" required>
                    </div>
                    <div class="form--group">
                        <textarea name="message" wrap="off" placeholder="<?php echo app('translator')->get('Write your message'); ?>" class="form--control" required><?php echo e(old('message')); ?></textarea>
                    </div>
                    <div class="form--group">
                        <button class="contact--btn"><?php echo app('translator')->get('Send Us Message'); ?></button>
                    </div>
                </form>
            </div>
        </div>
        <div class="col-lg-5">
            <div class="contact-info-wrapper">
                <h4 class="title"><?php echo app('translator')->get('Hotline'); ?>:</h4>
                <ul class="contact-list">
                   
                        <li><a href="tel:<?php echo e($contact->data_values->phone); ?>"><i class="las la-phone-volume"></i> <?php echo e(__($contact->data_values->phone)); ?></a></li>
                   
                </ul>
                <h4 class="title"><?php echo app('translator')->get('Email'); ?>:</h4>
                <ul class="contact-list">
                  
                        <li><a href="mailto:<?php echo e($contact->data_values->email); ?>"><i class="las la-envelope"></i> <?php echo e(__($contact->data_values->email)); ?></a></li>
                 
                </ul>
                <h4 class="title"><?php echo app('translator')->get('Address'); ?></h4>
                <p class="address">
                    <i class="las la-map"></i> <?php echo e(__(@$contact->data_values->address)); ?>

                </p>
            </div>
        </div>
    </div>
</section>
<!-- Contact Section Ends Here -->

<!-- Map Section Starts Here -->
<div class="gmaps-area">
    <iframe src = "https://maps.google.com/maps?q=<?php echo e(@$contact->data_values->map_latitude); ?>,<?php echo e(@$contact->data_values->map_longitude); ?>&hl=es;z=14&amp;output=embed"></iframe>
</div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make($activeTemplate.'layouts.frontend', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/fkyiliss/evangel-ace.com.ng/core/resources/views/templates/basic/contact.blade.php ENDPATH**/ ?>