<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <?php echo $__env->make('partials.seo', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <title><?php echo e($general->sitename(__($pageTitle))); ?></title>
    <?php echo $__env->make($activeTemplate.'layouts.partials.css', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
</head>
<body>
    <?php echo $__env->yieldPushContent('fbComment'); ?>
    <div class="overlay"></div>
    <div class="container main-container">
        <?php echo $__env->make($activeTemplate.'partials.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <div class="main-wrapper mt-2 p-0">
            <div class="main-content">
                <?php echo $__env->yieldContent('content'); ?>
            </div>
        </div>
        <?php echo $__env->make($activeTemplate.'partials.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    </div>

    <?php if(auth()->guard()->guest()): ?>
        <?php $cookie = App\Models\Frontend::where('data_keys','cookie.data')->first(); ?>
        <div class="cookie__wrapper <?php if(@$cookie->data_values->status && !session('cookie_accepted')): ?> active <?php endif; ?>">
            <div class="container">
                <p class="mb-3">
                    <?php echo @$cookie->data_values->description ?> <a class="text--secondary" href="<?php echo e(@$cookie->data_values->link); ?>" target="_blank"><?php echo app('translator')->get('Read Policy'); ?></a>
                </p>

                <div class="mt-3">
                    <a href="<?php echo e(route('cookie.accept')); ?>" class="cmn--btn btn--base btn--sm"><?php echo app('translator')->get('Accept'); ?></a>
                </div>
            </div>
        </div>
    <?php endif; ?>

    <a href="#0" class="scrollToTop active"><i class="las la-chevron-up"></i></a>
    <?php echo $__env->make($activeTemplate.'layouts.partials.js', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
</body>
</html>
<?php /**PATH /home/fkyiliss/evangel-ace.com.ng/core/resources/views/templates/basic/layouts/frontend.blade.php ENDPATH**/ ?>