<?php
    $bgImage = getContent('auth.content', true);
    $policyPages = getContent('policy_pages.element');
?>

<?php $__env->startSection('content'); ?>
<!-- Account Section Starts Here -->
<section class="account-section bg_img d-flex " style="background: url(<?php echo e(getImage('assets/images/frontend/auth/' .@$bgImage->data_values->image, '1920x1280')); ?>) right;">
    <div class="account-wrapper">
        <div class="logo mb-3">
            <a href="<?php echo e(route('home')); ?>"><img src="<?php echo e(getImage(imagePath()['logoIcon']['path'] .'/logo.png')); ?>" alt="logo"></a>
        </div>
        <h3 class="title mb-4"><?php echo app('translator')->get('Sign Up your Account'); ?></h3>
        <form class="account-form" action="<?php echo e(route('user.register')); ?>" method="POST" onsubmit="return submitUserForm();">
            <?php echo csrf_field(); ?>

            <?php if(session()->get('reference') != null): ?>
                <div class="form--group">
                    <input type="text" name="referBy" id="referenceBy" class="form--control" value="<?php echo e(session()->get('reference')); ?>" readonly>
                </div>
            <?php endif; ?>

            <div class="form--group">
                <input id="firstname" type="text" class="form--control" name="firstname" value="<?php echo e(old('firstname')); ?>" placeholder="<?php echo app('translator')->get('First Name'); ?>" required>
            </div>
            <div class="form--group">
                <input id="lastname" type="text" class="form--control" name="lastname" value="<?php echo e(old('lastname')); ?>" placeholder="<?php echo app('translator')->get('Last Name'); ?>" required>
            </div>
            <div class="form--group">
                <select name="country" id="country" class="form--control">
                    <?php $__currentLoopData = $countries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $country): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option data-mobile_code="<?php echo e($country->dial_code); ?>" value="<?php echo e($country->country); ?>" data-code="<?php echo e($key); ?>"><?php echo e(__($country->country)); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>
            <div class="form--group">
                <div class="input-group mb-3">
                    <input type="hidden" name="mobile_code">
                    <input type="hidden" name="country_code">

                    <div class="d-flex w-100">
                        <span class="input-group-text mobile-code"></span>
                        <input type="number" id="mobile" name="mobile" value="<?php echo e(old('mobile')); ?>" class="form--control w-100 checkUser" placeholder="<?php echo app('translator')->get('Mobile'); ?>" aria-label="<?php echo app('translator')->get('Mobile'); ?>" aria-describedby="basic-addon1">
                    </div>
                </div>
                <small class="text-danger mobileExist"></small>
            </div>
            <div class="form--group">
                <input id="username" type="text" class="form--control checkUser" name="username" value="<?php echo e(old('username')); ?>" placeholder="<?php echo app('translator')->get('Username'); ?>" required>
                <small class="text-danger usernameExist"></small>
            </div>
            <div class="form--group">
                <input id="email" type="email" class="form--control checkUser" name="email" value="<?php echo e(old('email')); ?>" placeholder="<?php echo app('translator')->get('Email'); ?>" required>
            </div>
            <div class="form--group hover-input-popup">
                <input id="password" type="password" class="form--control" name="password" required placeholder="<?php echo app('translator')->get('Password'); ?>">
                <?php if($general->secure_password): ?>
                    <div class="input-popup">
                      <p class="error lower"><?php echo app('translator')->get('1 small letter minimum'); ?></p>
                      <p class="error capital"><?php echo app('translator')->get('1 capital letter minimum'); ?></p>
                      <p class="error number"><?php echo app('translator')->get('1 number minimum'); ?></p>
                      <p class="error special"><?php echo app('translator')->get('1 special character minimum'); ?></p>
                      <p class="error minimum"><?php echo app('translator')->get('6 character password'); ?></p>
                    </div>
                <?php endif; ?>
            </div>
            <div class="form--group">
                <input id="password-confirm" type="password" class="form--control" name="password_confirmation" required autocomplete="new-password" placeholder="<?php echo app('translator')->get('Confirm Password'); ?>">
            </div>
            <div class="form--group">
                <?php echo loadReCaptcha() ?>
            </div>

            <?php echo $__env->make($activeTemplate.'partials.custom_captcha', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

            <?php if($general->agree): ?>
                <div class="form--group">
                    <div class="row">
                        <div class="col-md-12">
                            <div class="custom--checkbox">
                                <input type="checkbox" id="agree" name="agree">
                                <label for="agree" class="px-1"><?php echo app('translator')->get('I agree with'); ?></label>
                                <?php $__currentLoopData = $policyPages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $singlePolicy): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <a class="text--base" href="<?php echo e(route('policy.details', ['policy'=>slug($singlePolicy->data_values->title), 'id'=>$singlePolicy->id])); ?>" target="_blank"><?php echo e(__($singlePolicy->data_values->title)); ?></a>
                                    <?php if(!$loop->last): ?> , &nbsp; <?php endif; ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        </div>
                    </div>
                </div>
            <?php endif; ?>

            <div class="form--group">
                <button type="submit" class="login"><?php echo app('translator')->get('Sign Up'); ?></button>
            </div>

        </form>
        <h5><?php echo app('translator')->get('Already Account Here'); ?>?
            <a class="text--base" href="<?php echo e(route('user.login')); ?>"><?php echo app('translator')->get('Log In'); ?></a>
        </h5>
    </div>
</section>
<!-- Account Section Ends Here -->

<div class="modal fade" id="existModalCenter" tabindex="-1" role="dialog" aria-labelledby="existModalCenterTitle" aria-hidden="true">
  <div class="modal-dialog modal-dialog-centered" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="existModalLongTitle"><?php echo app('translator')->get('You are with us'); ?></h5>
      </div>
      <div class="modal-body">
        <h6 class="text-center"><?php echo app('translator')->get('You already have an account please Sign in '); ?></h6>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal"><?php echo app('translator')->get('Close'); ?></button>
        <a href="<?php echo e(route('user.login')); ?>" class="btn btn--primary"><?php echo app('translator')->get('Login'); ?></a>
      </div>
    </div>
  </div>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('style'); ?>
<style>
    .country-code .input-group-prepend .input-group-text{
        background: #fff !important;
    }
    .country-code select{
        border: none;
    }
    .country-code select:focus{
        border: none;
        outline: none;
    }
    .hover-input-popup {
        position: relative;
    }
    .hover-input-popup:hover .input-popup {
        opacity: 1;
        visibility: visible;
    }
    .input-popup {
        position: absolute;
        bottom: 130%;
        left: 50%;
        width: 280px;
        background-color: #1a1a1a;
        color: #fff;
        padding: 20px;
        border-radius: 5px;
        -webkit-border-radius: 5px;
        -moz-border-radius: 5px;
        -ms-border-radius: 5px;
        -o-border-radius: 5px;
        -webkit-transform: translateX(-50%);
        -ms-transform: translateX(-50%);
        transform: translateX(-50%);
        opacity: 0;
        visibility: hidden;
        -webkit-transition: all 0.3s;
        -o-transition: all 0.3s;
        transition: all 0.3s;
    }
    .input-popup::after {
        position: absolute;
        content: '';
        bottom: -19px;
        left: 50%;
        margin-left: -5px;
        border-width: 10px 10px 10px 10px;
        border-style: solid;
        border-color: transparent transparent #1a1a1a transparent;
        -webkit-transform: rotate(180deg);
        -ms-transform: rotate(180deg);
        transform: rotate(180deg);
    }
    .input-popup p {
        padding-left: 20px;
        position: relative;
    }
    .input-popup p::before {
        position: absolute;
        content: '';
        font-family: 'Line Awesome Free';
        font-weight: 900;
        left: 0;
        top: 4px;
        line-height: 1;
        font-size: 18px;
    }
    .input-popup p.error {
        text-decoration: line-through;
    }
    .input-popup p.error::before {
        content: "\f057";
        color: #ea5455;
    }
    .input-popup p.success::before {
        content: "\f058";
        color: #28c76f;
    }
    .checkUser{
        border-radius: 0 5px 5px 0
    }
    .mobile-code{
        border-radius: 5px 0px 0px 5px;
        background: #115eec;
        color: #fff
    }
</style>
<?php $__env->stopPush(); ?>
<?php $__env->startPush('script-lib'); ?>
<script src="<?php echo e(asset('assets/global/js/secure_password.js')); ?>"></script>
<?php $__env->stopPush(); ?>
<?php $__env->startPush('script'); ?>
    <script>
      "use strict";
        function submitUserForm() {
            var response = grecaptcha.getResponse();
            if (response.length == 0) {
                document.getElementById('g-recaptcha-error').innerHTML = '<span class="text-danger"><?php echo app('translator')->get("Captcha field is required."); ?></span>';
                return false;
            }
            return true;
        }
        (function ($) {
            <?php if($mobile_code): ?>
            $(`option[data-code=<?php echo e($mobile_code); ?>]`).attr('selected','');
            <?php endif; ?>

            $('select[name=country]').change(function(){
                $('input[name=mobile_code]').val($('select[name=country] :selected').data('mobile_code'));
                $('input[name=country_code]').val($('select[name=country] :selected').data('code'));
                $('.mobile-code').text('+'+$('select[name=country] :selected').data('mobile_code'));
            });
            $('input[name=mobile_code]').val($('select[name=country] :selected').data('mobile_code'));
            $('input[name=country_code]').val($('select[name=country] :selected').data('code'));
            $('.mobile-code').text('+'+$('select[name=country] :selected').data('mobile_code'));
            <?php if($general->secure_password): ?>
                $('input[name=password]').on('input',function(){
                    secure_password($(this));
                });
            <?php endif; ?>

            $('.checkUser').on('focusout',function(e){
                var url = '<?php echo e(route('user.checkUser')); ?>';
                var value = $(this).val();
                var token = '<?php echo e(csrf_token()); ?>';
                if ($(this).attr('name') == 'mobile') {
                    var mobile = `${$('.mobile-code').text().substr(1)}${value}`;
                    var data = {mobile:mobile,_token:token}
                }
                if ($(this).attr('name') == 'email') {
                    var data = {email:value,_token:token}
                }
                if ($(this).attr('name') == 'username') {
                    var data = {username:value,_token:token}
                }
                $.post(url,data,function(response) {
                  if (response['data'] && response['type'] == 'email') {
                    $('#existModalCenter').modal('show');
                  }else if(response['data'] != null){
                    $(`.${response['type']}Exist`).text(`${response['type']} already exist`);
                  }else{
                    $(`.${response['type']}Exist`).text('');
                  }
                });
            });

        })(jQuery);

    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make($activeTemplate.'layouts.auth_master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/fkyiliss/evangel-ace.com.ng/core/resources/views/templates/basic/user/auth/register.blade.php ENDPATH**/ ?>