<?php $__env->startSection('content'); ?>

    <div class="col-lg-9">
        
        <div class="create__ticket">
            <div class="create__ticket__header">
                <h5 class="title"><?php echo app('translator')->get('Create New Ticket'); ?></h5>
                <a href="<?php echo e(route('ticket')); ?>" class="cmn--btn btn--sm bg--primary text--white"><span><?php echo app('translator')->get('All Tickets'); ?></span></a>
            </div>
            <div class="create__ticket__body">
                <form class="create__ticket__form row"  action="<?php echo e(route('ticket.store')); ?>"  method="post" enctype="multipart/form-data">
                    <?php echo csrf_field(); ?>
                    <div class="form--group col-sm-6">
                        <label for="name" class="form--label"><?php echo app('translator')->get('Your Name'); ?></label>
                        <input type="text" id="name" name="name" class="form-control form--control" value="<?php echo e(auth()->user()->fullname); ?>" required>
                    </div>
                    <div class="form--group col-sm-6">
                        <label for="email" class="form--label"><?php echo app('translator')->get('Your Email'); ?></label>
                        <input type="text" id="email" name="email" class="form-control form--control" value="<?php echo e(auth()->user()->email); ?>" required>
                    </div>
                    <div class="form--group col-sm-12">
                        <label for="subject" class="form--label"><?php echo app('translator')->get('Your Subject'); ?></label>
                        <input type="text" id="subject" name="subject" class="form-control form--control" required>
                    </div>
                    <div class="form-group col-sm-12">
                        <label for="priority"><?php echo app('translator')->get('Priority'); ?></label>
                        <select name="priority" class="form-control form--control">
                            <option value="3"><?php echo app('translator')->get('High'); ?></option>
                            <option value="2"><?php echo app('translator')->get('Medium'); ?></option>
                            <option value="1"><?php echo app('translator')->get('Low'); ?></option>
                        </select>
                    </div>
                    <div class="form--group col-sm-12">
                        <label for="message" class="form--label"><?php echo app('translator')->get('Your Message'); ?></label>
                        <textarea id="message" class="form-control form--control" name="message" required></textarea>
                    </div>
                    <div class="form--group col-sm-12">
                        <div class="d-flex">
                            <div class="left-group col p-0">
                                <label for="file2" class="form--label"><?php echo app('translator')->get('Attachments'); ?></label>
                                <input type="file" class="overflow-hidden form-control form--control mb-2 ms-0" name="attachments[]" id="file2">
                                <div id="fileUploadsContainer" class="mb-2"></div>
                                <span class="info fs--14"><?php echo app('translator')->get('Allowed File Extensions'); ?>: .<?php echo app('translator')->get('jpg'); ?>, .<?php echo app('translator')->get('jpeg'); ?>, .<?php echo app('translator')->get('png'); ?>, .<?php echo app('translator')->get('pdf'); ?>, .<?php echo app('translator')->get('doc'); ?>, .<?php echo app('translator')->get('docx'); ?></span>
                            </div>
                            <div class="add-area">
                                <label class="form--label d-block">&nbsp;</label>
                                <button class="ms-3  bg--primary addFile" type="button"><i class="las la-plus"></i></button>
                            </div>
                        </div>
                    </div>
                    <div class="form--group col-sm-12 mb-0">
                        <button class="mt-sm-2 bg--primary" type="submit"><?php echo app('translator')->get('Create Ticket'); ?></button>
                    </div>
                </form> 
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>


<?php $__env->startPush('script'); ?>
    <script>
        (function ($) {
            "use strict";
            $('.addFile').on('click',function(){
                $("#fileUploadsContainer").append(`
                    <div class="input-group mt-3">
                        <input type="file" class="overflow-hidden form-control form--control ms-0" name="attachments[]" id="file2">
                        <button class="input-group-text btn btn--danger remove-btn">x</button>
                        
                    </div>
                `)
            });
            $(document).on('click','.remove-btn',function(){
                $(this).closest('.input-group').remove();
            });
        })(jQuery);
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make($activeTemplate.'layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/fkyiliss/evangel-ace.com.ng/core/resources/views/templates/basic/user/support/create.blade.php ENDPATH**/ ?>