<?php $__env->startSection('panel'); ?>

<div class="invoice-wrapper" id="printarea">
    <div class="invoice-header row justify-content-between pb-4">
        <div class="col-2"><div class="logo"><img src="<?php echo e(getImage(imagePath()['logoIcon']['path'] .'/logo.png')); ?>" alt=""></div></div>
        <div class="col-lg-10">

        </div>
    </div>
    <h2 class="title text-center mb-4 pb-2 border-bottom text--dark"><?php echo app('translator')->get('Invoice'); ?></h2>
    <div class="invoice-body">
        <div class="invoice-info row justify-content-between">
            <div class="col-3">
                <ul class="invoice-info">
                    <li><h6 class="title mb-2"><?php echo app('translator')->get('Bill Form'); ?>:</h6></li>
                    <li><?php echo e($general->sitename); ?></li>
                    <li><?php echo e($contact->data_values->email); ?></li>
                     <li><?php echo e($contact->data_values->phone); ?></li>
                </ul>
            </div>
            <div class="col-3">
                <ul class="invoice-info">
                    <li><h6 class="title mb-2"><?php echo app('translator')->get('Bill To'); ?>:</h6></li>
                    <li><?php echo e($order->shipping->name); ?></li>
                    <li><?php echo e(@$order->shipping->address); ?></li>
                    <li><?php echo e($order->shipping->email); ?></li>
                    <li><?php echo e($order->shipping->phone); ?></li>
                </ul>
            </div>
            <div class="col-4">
                <ul class="invoice-details">
                    <li>
                        <h6 class="title"><?php echo app('translator')->get('INVOICE DATE'); ?> #</h6>
                        <span class="value"><?php echo e(now()->format('d M Y')); ?></span>
                    </li>

                    <li>
                        <h6 class="title"><?php echo app('translator')->get('PAYMENT'); ?> #</h6>
                        <span class="value"><?php echo e($order->payment_type == 1 ? 'Direct Payment':'Cash On Delivery'); ?></span>
                    </li>

                    <li>
                        <h6 class="title"><?php echo app('translator')->get('ORDER ID'); ?> #</h6>
                        <span class="value"><?php echo e($order->order_track); ?></span>
                    </li>
                </ul>
            </div>
        </div>
        <table class="invoice-product-table">
            <thead>
                <tr>
                    <th><?php echo app('translator')->get('Product'); ?></th>
                    <th><?php echo app('translator')->get('Quantity'); ?></th>
                    <th><?php echo app('translator')->get('Price'); ?></th>
                    <th><?php echo app('translator')->get('Total'); ?></th>
                </tr>
            </thead>
            <tbody>
                <tr>
                    <td>
                        <div class="item">
                            <h6 class="name mb-1"><?php echo e($order->product->name); ?></h6>
                        </div>
                    </td>
                    <td><?php echo e($order->qty); ?></td>
                    <td><?php echo e($general->cur_sym); ?><?php echo e(getAmount($order->product_price)); ?></td>
                    <td><?php echo e($general->cur_sym); ?><?php echo e(getAmount($order->total_amount)); ?></td>
                </tr>

            </tbody>
        </table>
        <ul class="invoice-amount-wrapper">

            <li class="total-amount py-2">
                <h6 class="title"><?php echo app('translator')->get('Total'); ?></h6>
                <span class="value"><?php echo e($general->cur_sym); ?><?php echo e(getAmount($order->total_amount)); ?></span>
            </li>
        </ul>


        <div class="invoice-footer">
            <ul class="d-flex justify-content-center">
               <?php echo app('translator')->get('For more products visit : '.url('/')); ?>
            </ul>
        </div>
    </div>
</div>

<div class="row justify-content-center mt-4">
    <div class="col-md-3 text-center">
        <button class="btn btn--primary w-100 mb-2" id="print"><?php echo app('translator')->get('Print'); ?></button>

    </div>
    <div class="col-md-3 text-center">
        <button class="btn btn--dark w-100" id="pdf"><?php echo app('translator')->get('Downlaod'); ?></button>

    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('style-lib'); ?>
    <link rel="stylesheet" href="<?php echo e(asset('assets/admin/css/dev_custom.css')); ?>">
<?php $__env->stopPush(); ?>

<?php $__env->startPush('script'); ?>

<script src="<?php echo e(asset('assets/global/js/html2pdf.bundle.min.js')); ?>"></script>
<script>
    "use strict";

    const options = {
    margin: 0.3,
    filename: '<?php echo e($order->order_track); ?>',
    image: {
        type: 'jpeg',
        quality: 1.00
    },
    html2canvas: {
        scale: 4
    },
    jsPDF: {
        unit: 'in',
        format: 'letter',
        orientation: 'landscape'
    }
    }
    var objstr = document.getElementById('printarea').innerHTML;
    var strr = objstr;
    $(document).on('click','#pdf',function(e){
        e.preventDefault();
        var element = document.getElementById('pdf');
        html2pdf().from(strr).set(options).save();
    });

    $('#print').on('click', function () {
            window.print()
        });
</script>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('breadcrumb-plugins'); ?>
    <a href="<?php echo e(route('admin.orders')); ?>" class="btn btn--dark"><?php echo app('translator')->get('Go Back'); ?></a>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/fkyiliss/evangel-ace.com.ng/core/resources/views/admin/orders/details.blade.php ENDPATH**/ ?>