<?php
    $header = getContent('header.content', true);
?>
<!-- Header Section Starts Here -->
<div class="header-top">
    <div class="header-top-area">
        <div class="logo d-none d-md-block"><a href="<?php echo e(route('home')); ?>"><img src="<?php echo e(getImage(imagePath()['logoIcon']['path'] .'/logo.png')); ?>" alt="<?php echo app('translator')->get('logo'); ?>"></a></div>
        <div class="rolling-headline"><marquee scrollamount="4"><?php echo e(__(@$header->data_values->notice)); ?></marquee></div>
        <div class="header-contacts">
            <p><?php echo e(__(@$header->data_values->heading)); ?></p>
            <a href="tel:<?php echo e(@$header->data_values->phone); ?>"><?php echo e(@$header->data_values->phone); ?></a>
        </div>
    </div>
</div>


<div class="header-bottom">
    <div class="header-bottom-area justify-content-between align-items-center justify-content-lg-between">
        <div class="menu-wrapper w-100">
            <ul class="menu">

                <li class="close-trigger d-md-none text-end">
                    <span class="close-menu-trigger">
                        <i class="las la-times"></i>
                    </span>
                </li>

                <li>
                    <a href="<?php echo e(route('home')); ?>"><?php echo app('translator')->get('Home'); ?></a>
                </li>

                <li>
                    <a href="<?php echo e(route('products')); ?>"><?php echo app('translator')->get('Products'); ?></a>
                </li>

                <?php if($categories->count()): ?>
                <li>
                    <a href="#0"><?php echo app('translator')->get('Category'); ?></a>
                    <ul class="sub-menu">
                        <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cat): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <li>
                            <a href="<?php echo e(route('products',['category'=>$cat->slug])); ?>"><?php echo app('translator')->get($cat->name); ?></a>
                        </li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                    </ul>
                </li>
                <?php endif; ?>
                <?php if(auth()->guard()->guest()): ?>
                    <li>
                        <a href="<?php echo e(route('blogs')); ?>"><?php echo app('translator')->get('Blog'); ?></a>
                    </li>

                    <li>
                        <a href="<?php echo e(route('about')); ?>"><?php echo app('translator')->get('About'); ?></a>
                    </li>

                    <li>
                        <a href="<?php echo e(route('contact')); ?>"><?php echo app('translator')->get('Contact'); ?></a>
                    </li>

                    <li>
                        <a href="<?php echo e(route('user.login')); ?>"><?php echo app('translator')->get('Login'); ?></a>
                    </li>
                <?php endif; ?>

                <?php if(auth()->guard()->check()): ?>
                    <li>
                        <a href="<?php echo e(route('ticket')); ?>"><?php echo app('translator')->get('Support'); ?></a>
                    </li>
                    <li>
                        <a href="<?php echo e(route('user.home')); ?>"><?php echo app('translator')->get('Dashboard'); ?></a>
                    </li>
                <?php endif; ?>

                <li class="ms-auto search-toggler-btn d-md-block d-none">
                    <div class="search-toggler">
                        <div class="search-icon">
                            <?php if(request()->search): ?>
                            <i class="las la-times"></i>
                            <?php else: ?>
                            <i class="las la-search"></i>
                            <?php endif; ?>
                        </div>
                    </div>
                </li>
            </ul>   <!-- Menu End -->

            <div class="header-search-bar <?php if(request()->search): ?> show <?php endif; ?>">
                <form  class="search-form pt-md-3 pb-3 pb-md-0" action="<?php echo e(route('products')); ?>" id="searchForm">
                    <input type="text" class="form-control form--control" name="search" placeholder="<?php echo app('translator')->get('Search products by keywords'); ?>" value="<?php echo e(request('search')); ?>">
                    <button class="search--button bg--primary" type="submit"><i class="las la-search"></i></button>
                </form>
            </div>
        </div>
        <div class="logo d-md-none me-auto"><a href="<?php echo e(route('home')); ?>"><img src="<?php echo e(getImage(imagePath()['logoIcon']['path'] .'/logo.png')); ?>" alt="<?php echo app('translator')->get('logo'); ?>"></a></div>

        <div class="header-trigger-wrapper d-flex d-md-none align-items-center me-0">
            <div class="header-trigger d-block d-lg-none">
                <span></span>
            </div>
        </div>  <!-- Trigger End-->
        <div class="search-toggler d-md-none">
            <div class="search-icon text-dark">
                <i class="las la-search"></i>
            </div>
        </div>


    </div>
</div>
<!-- Header Section Ends Here -->
<?php /**PATH /home/fkyiliss/evangel-ace.com.ng/core/resources/views/templates/basic/partials/header.blade.php ENDPATH**/ ?>