<?php $__env->startSection('content'); ?>
<div class="row p-0">
    <div class="col-lg-3">
        <div class="product-sidebar">
            <div class="product-sidebar-close">
                <i class="las la-times"></i>
            </div>
            <div class="sidebar-item">
                <h4 class="title ms-2"><?php echo app('translator')->get('Product Categories'); ?></h4>
                <ul class="product-cate">
                    <li>
                        <select  class="form-control shadow-none outline-0 cat-with" onChange="window.location.href=this.value">
                            <option value="<?php echo e(queryBuild('category','')); ?>"><?php echo app('translator')->get('All'); ?></option>
                            <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cat): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e(queryBuild('category',$cat->slug)); ?>" <?php echo e(request('category') == $cat->slug ? 'selected':''); ?>><?php echo e($cat->name); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </li>
                </ul>
            </div>
            <div class="sidebar-item">
                <h4 class="title ms-2"><?php echo app('translator')->get('Product Brands'); ?></h4>
                <ul class="product-cate">
                    <li>
                        <select  class="form-control shadow-none outline-0 cat-with" onChange="window.location.href=this.value">
                            <option value="<?php echo e(queryBuild('brand','')); ?>"><?php echo app('translator')->get('All'); ?></option>
                            <?php $__currentLoopData = $brands; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $brand): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                              <option value="<?php echo e(queryBuild('brand',$brand->slug)); ?>" <?php echo e(request('brand') == $brand->slug ? 'selected':''); ?>><?php echo e($brand->name); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </li>
                </ul>
            </div>
            <div class="sidebar-item">
                <h4 class="title ms-2"><?php echo app('translator')->get('Product Attribute'); ?></h4>
                <ul class="product-cate">
                    <li>
                        <a href="<?php echo e(queryBuild('attribute','hot-deal')); ?>" class="custom--checkbox">
                            <input id="7" type="checkbox" class="form--control" name="attribute" value="<?php echo e(queryBuild('attribute','hot-deal')); ?>" <?php echo e(request('attribute')=='hot-deal'?'checked':''); ?>>
                            <label for="7"><?php echo app('translator')->get('Hot Deal'); ?></label>
                        </a>
                    </li>
                    <li>
                        <a href="<?php echo e(queryBuild('attribute','discounted')); ?>" class="custom--checkbox">
                            <input id="8" type="checkbox" class="form--control" name="attribute" value="<?php echo e(queryBuild('attribute','discounted')); ?>" <?php echo e(request('attribute')=='discounted'?'checked':''); ?>>
                            <label for="8"><?php echo app('translator')->get('Discount'); ?></label>
                        </a>
                    </li>
                    <li>
                        <a href="<?php echo e(queryBuild('attribute','featured')); ?>" class="custom--checkbox">
                            <input id="9" type="checkbox" class="form--control" name="attribute" value="<?php echo e(queryBuild('attribute','featured')); ?>" <?php echo e(request('attribute')=='featured'?'checked':''); ?>>
                            <label for="9"><?php echo app('translator')->get('Featured'); ?></label>
                        </a>
                    </li>
                </ul>
            </div>

        </div>
    </div>
    <div class="col-lg-9">
        <div class="main-content">



            <!-- Feature Products Section Starts Here -->
            <section class="products-section">
                <h3 class="section-title d-flex justify-content-between">
                    <span><?php echo app('translator')->get($pageTitle); ?></span>
                    <span class="sidebar-active d-lg-none">
                        <i class="las la-bars"></i>
                    </span>
                </h3>

                <div class="row g-2">
                    <?php $__empty_1 = true; $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <div class="col-md-4 col-sm-6">
                        <div class="product-item">
                            <div class="thumb"><img src="<?php echo e(getImage(imagePath()['product']['path'].'/'.$item->image,imagePath()['product']['size'])); ?>" alt="products">
                                <?php if(!$item->stock): ?>
                                    <span class="stock-status badge bg--danger"><?php echo app('translator')->get("Stock Out"); ?></span>
                                <?php endif; ?>
                            </div>

                            <div class="content">
                            <h5 class="product-name"><a href="<?php echo e(route('product.details',[$item->id,$item->slug])); ?>"><?php echo app('translator')->get($item->name); ?></a></h5>
                                <?php if($item->discount > 0): ?>
                                <div class="d-flex justify-content-between">
                                    <span class="price"><?php echo e($general->cur_sym); ?><?php echo e(afterDiscount($item->price,$item->discount)); ?></span>
                                    <del class="discounted"><?php echo e($general->cur_sym); ?><?php echo e(getAmount($item->price)); ?></del>
                                </div>
                                <?php else: ?>
                                <span class="price"><?php echo e($general->cur_sym); ?><?php echo e(getAmount($item->price)); ?></span>
                                <?php endif; ?>
                                <div class="button-wrapper">
                                    <a href="<?php echo e(route('checkout',[$item->id,$item->slug])); ?>" class="cmn--btn bg--primary btn--md"><?php echo app('translator')->get('Order Now'); ?></a>
                                    <a href="<?php echo e(route('product.details',[$item->id,$item->slug])); ?>" class="cmn--btn bg--base btn--md"><?php echo app('translator')->get('View Details'); ?></a>
                                </div>
                            </div>
                        </div>
                    </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <div class="text-center mt-5">
                            <h4><?php echo app('translator')->get('No products found'); ?></h4>
                        </div>
                    <?php endif; ?>
                </div>
            </section>

            <div class="my-4">
                <?php echo e(paginateLinks($products,'')); ?>

            </div>

        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('style'); ?>
    <style>
        .cat-with{
            width: 90%!important;
        }
    </style>
<?php $__env->stopPush(); ?>
<?php
    $searchUrl =  http_build_query(request()->except('search'));
    $searchUrl =   str_replace("amp%3B","",$searchUrl);
    $queryStrings = json_encode(request()->query());
?>
<?php $__env->startPush('script'); ?>
     <script>
            'use strict';
            (function ($) {

                $('input[name=attribute]').on('change',function () {
                    if(!$(this).prop('checked')){
                         var url = '<?php echo e(url()->current()); ?>?<?php echo e(http_build_query(request()->except('attribute'))); ?>';
                         window.location.href = url.replace('amp;','')
                         return false
                    }
                    window.location.href = $(this).val()
                 })


            })(jQuery);
     </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make($activeTemplate.'layouts.frontend', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/fkyiliss/evangel-ace.com.ng/core/resources/views/templates/basic/products.blade.php ENDPATH**/ ?>