<?php $__env->startSection('content'); ?>

<div class="col-xl-9">
        <div class="row justify-content-end mb-3">
            <div class="col-lg-5">
                <form action="">
                    <div class="input-group">
                        <input type="text" name="search" class="form-control shadow-none outline-0 border--primary" placeholder="<?php echo app('translator')->get('Order ID'); ?>" value="<?php echo e($search??''); ?>">
                        <button type="submit" class="input-group-text bg--primary  text-white border--primary"><i class="las la-search"></i></button>
                    </div>
                </form>
            </div>
        </div>
        <table class="transection-table-2 box__shadow w-100">
            <thead>
                <tr>
                    <th><?php echo app('translator')->get('Date'); ?></th>
                    <th><?php echo app('translator')->get('Order ID'); ?></th>
                    <th><?php echo app('translator')->get('Product'); ?></th>
                    <th><?php echo app('translator')->get('Payment'); ?></th>
                    <th><?php echo app('translator')->get('Status'); ?></th>
                    <th><?php echo app('translator')->get('Qty'); ?></th>
                    <th><?php echo app('translator')->get('Amount'); ?></th>
                    <th><?php echo app('translator')->get('Action'); ?></th>

                </tr>
            </thead>
            <tbody>
                <?php $__empty_1 = true; $__currentLoopData = $orders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <tr>
                    <td class="date" data-label="<?php echo app('translator')->get('Date'); ?>">
                        <?php echo e(showDateTime($order->created_at,'d M Y')); ?>

                    </td>

                    <td class="trx-id" data-label="<?php echo app('translator')->get('Order ID'); ?>"><?php echo e($order->order_track); ?></td>

                    <td  data-label="<?php echo app('translator')->get('Product Name'); ?>"><a target="_blank" href="<?php echo e(route('product.details',[$order->product->id,$order->product->slug])); ?>"><?php echo e(shortDescription(@$order->product->name,20)); ?></a></td>

                    <td  data-label="<?php echo app('translator')->get('Payment Type'); ?>">
                        <?php if($order->payment_type == 1): ?>
                            <?php echo app('translator')->get('Direct'); ?>
                        <?php else: ?>
                            <span title="<?php echo app('translator')->get('Cash On Delivery'); ?>"><?php echo app('translator')->get('COD'); ?></span>
                        <?php endif; ?>
                    </td>

                    <td  data-label="<?php echo app('translator')->get('Order Status'); ?>">
                        <?php if(!$order->status): ?>
                            <span class="badge bg--warning badge--md"><?php echo app('translator')->get('Pending'); ?></span>
                        <?php elseif($order->status == 1): ?>
                            <span class="badge bg--success badge--md"><?php echo app('translator')->get('Delivered'); ?></span>
                        <?php elseif($order->status == 2): ?>
                            <span class="badge bg--info badge--md"><?php echo app('translator')->get('Processing'); ?></span>
                        <?php elseif($order->status == 3): ?>
                             <span class="badge bg--danger badge--md"><?php echo app('translator')->get('Cancelled'); ?></span>
                        <?php endif; ?>
                    </td>

                    <td class="amount" data-label="<?php echo app('translator')->get('Qty'); ?>">
                        <?php echo e($order->qty); ?>

                    </td>

                    <td class="amount" data-label="<?php echo app('translator')->get('Total Amount'); ?>">
                        <?php echo e($general->cur_sym); ?><?php echo e(getAmount($order->total_amount)); ?>

                    </td>

                    <td>
                        <?php if($order->pay_status != 1 && $order->status == 0): ?>
                            <button class="icon--btn btn--danger cancel" data-id="<?php echo e($order->id); ?>" data-route="<?php echo e(route('user.cancel.order')); ?>">
                                <i class="fa fa-times-circle"></i>
                            </button>
                        <?php else: ?>
                            <button class="icon--btn btn--danger disabled"><i class="fa fa-times-circle"></i></button>
                        <?php endif; ?>
                    </td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <tr>
                    <td class="text-muted text-center" colspan="100%"><?php echo app('translator')->get('No order found'); ?></td>
                </tr>
                <?php endif; ?>
            </tbody>
        </table>
        <?php echo e(paginateLinks($orders,'')); ?>

   </div>

    <div class="modal fade" id="cancelModal" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <form action="" method="POST">
                    <?php echo csrf_field(); ?>
                    <input type="hidden" name="id">
                    <div class="modal-body text-center">
                        <i class="las la-exclamation-circle text-danger display-2 mb-15"></i>
                        <h4 class="text--dark mb-15"><?php echo app('translator')->get('Are you sure want to cancel this order?'); ?></h4>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn--dark h-auto" data-bs-dismiss="modal"><?php echo app('translator')->get('No'); ?></button>
                        <button type="submit"  class="btn--danger  h-auto del"><?php echo app('translator')->get('Yes'); ?></button>
                    </div>
                </form>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('style'); ?>
    <style>
        .cancel{
            cursor: pointer;
        }
    </style>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('script'); ?>
     <script>
            'use strict';
            (function ($) {
                $('.cancel').on('click',function(){
                    var route = $(this).data('route')
                    var modal = $('#cancelModal');
                    modal.find('input[name=id]').val($(this).data('id'))
                    modal.find('form').attr('action',route)
                    modal.modal('show');
                })
            })(jQuery);
     </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make($activeTemplate.'layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/fkyiliss/evangel-ace.com.ng/core/resources/views/templates/basic/user/order_history.blade.php ENDPATH**/ ?>