<?php $__env->startSection('content'); ?>
<section class="user-dashboard pt-50 pb-50">
    <div class="container">
        <div class="row">
            <?php $__currentLoopData = $gatewayCurrency; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="col-lg-3 col-md-3 mb-4">
                    <div class="card">
                        <h5 class="card-header text-center bg--primary text-white"><?php echo e(__($data->name)); ?>

                        </h5>
                        <div class="card-body card-body-deposit">
                            <img src="<?php echo e($data->methodImage()); ?>" class="card-img-top" alt="<?php echo e(__($data->name)); ?>" class="w-100">
                        </div>
                        <div class="card-footer">
                            <form action="<?php echo e(route('user.deposit.insert')); ?>" method="POST" class="payment-form">
                                <?php echo csrf_field(); ?>
                                <input type="hidden" name="currency"  value="<?php echo e($data->currency); ?>">
                                <input type="hidden" name="method_code" value="<?php echo e($data->method_code); ?>">
                                <button class="btn btn--primary text-white  w-100 prevent-double-click"><?php echo app('translator')->get('Pay Now'); ?></button>
                            </form>
                        </div>
                    </div>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </div>
</section>

<?php $__env->stopSection(); ?>



<?php $__env->startPush('script'); ?>
    <script>
        (function ($) {
            "use strict";
            $('.prevent-double-click').on('click',function(){
                $(this).attr('disabled',true);
                $(this).html('<i class="fas fa-spinner fa-spin"></i> <?php echo app('translator')->get('Processing'); ?>...');
                $(this).parents('.payment-form').submit()
            });
        })(jQuery);
    </script>
<?php $__env->stopPush(); ?>



<?php echo $__env->make($activeTemplate.'layouts.frontend', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/fkyiliss/evangel-ace.com.ng/core/resources/views/templates/basic/user/payment/deposit.blade.php ENDPATH**/ ?>