<?php $__env->startSection('content'); ?>

<div class="row">
    <div class="<?php if($hotDealProducts->count()): ?> col-xl-9 <?php else: ?> col-xl-12 <?php endif; ?>">
        <?php echo $__env->make($activeTemplate.'partials.banner', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <?php if($featuredProducts->count()): ?>
            <section class="products-section">
                <h3 class="section-title"><?php echo app('translator')->get('Feature Products'); ?></h3>
                <div class="row g-2">
                    <?php $__currentLoopData = $featuredProducts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="col-lg-4 col-sm-6">
                            <div class="product-item">
                                <div class="thumb">
                                    <img src="<?php echo e(getImage(imagePath()['product']['path'].'/'.$item->image,imagePath()['product']['size'])); ?>" alt="products">

                                    <?php if(!$item->stock): ?>
                                        <span class="stock-status badge bg--danger"><?php echo app('translator')->get("Stock Out"); ?></span>
                                    <?php endif; ?>
                                </div>
                                <div class="content">
                                    <h5 class="product-name"><a href="<?php echo e(route('product.details',[$item->id,$item->slug])); ?>"><?php echo app('translator')->get($item->name); ?></a></h5>
                                    <?php if($item->discount > 0): ?>
                                        <div class="d-flex justify-content-between">
                                            <span class="price"><?php echo e($general->cur_sym); ?><?php echo e(afterDiscount($item->price,$item->discount)); ?></span>
                                            <del class="discounted"><?php echo e($general->cur_sym); ?><?php echo e(getAmount($item->price)); ?></del>
                                        </div>
                                    <?php else: ?>
                                    <span class="price"><?php echo e($general->cur_sym); ?><?php echo e(getAmount($item->price)); ?></span>
                                    <?php endif; ?>

                                    <div class="button-wrapper">
                                        <a href="<?php echo e(route('checkout',[$item->id,$item->slug])); ?>" class="cmn--btn btn--md bg--primary"><?php echo app('translator')->get('Order Now'); ?></a>
                                        <a href="<?php echo e(route('product.details',[$item->id,$item->slug])); ?>" class="cmn--btn btn--md bg--base"><?php echo app('translator')->get('View Details'); ?></a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </section>
        <?php endif; ?>

        <?php if($latestProducts->count()): ?>
            <section class="products-section">
                <h3 class="section-title"><?php echo app('translator')->get('Latest Products'); ?></h3>
                <div class="row g-2">
                    <?php $__currentLoopData = $latestProducts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="col-lg-4 col-sm-6">
                        <div class="product-item">
                            <div class="thumb">
                                <img src="<?php echo e(getImage(imagePath()['product']['path'].'/'.$product->image,imagePath()['product']['size'])); ?>" alt="products">
                                <?php if(!$product->stock): ?>
                                    <span class="stock-status badge bg--danger"><?php echo app('translator')->get("Stock Out"); ?></span>
                                <?php endif; ?>
                            </div>
                            <div class="content">
                            <h5 class="product-name"><a href="<?php echo e(route('product.details',[$product->id,$product->slug])); ?>"><?php echo app('translator')->get($product->name); ?></a></h5>
                            <?php if($product->discount > 0): ?>
                            <div class="d-flex justify-content-between">
                                <span class="price"><?php echo e($general->cur_sym); ?><?php echo e(afterDiscount($product->price,$item->discount)); ?></span>
                                <del class="discounted"><?php echo e($general->cur_sym); ?><?php echo e(getAmount($product->price)); ?></del>
                            </div>
                            <?php else: ?>
                            <span class="price"><?php echo e($general->cur_sym); ?><?php echo e(getAmount($product->price)); ?></span>
                            <?php endif; ?>
                                <div class="button-wrapper">
                                    <a href="<?php echo e(route('checkout',[$product->id,$product->slug])); ?>" class="cmn--btn btn--md bg--primary"><?php echo app('translator')->get('Order Now'); ?></a>
                                    <a href="<?php echo e(route('product.details',[$product->id,$product->slug])); ?>" class="cmn--btn btn--md bg--base"><?php echo app('translator')->get('View Details'); ?></a>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </section>
        <?php endif; ?>
    </div>

    <?php if($hotDealProducts->count()): ?>
        <div class="col-xl-3">
            <div class="hot-product-sidebar">
                <h3 class="title"><?php echo app('translator')->get('Hot Deals'); ?></h3>
                <div class="row g-4">
                    <?php $__currentLoopData = $hotDealProducts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $deal): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="col-md-6 col-lg-3 col-xl-12 col-sm-6">
                            <div class="hot-item m-0">
                                <div class="thumb">
                                    <?php if(!$deal->stock): ?>
                                        <span class="stock-status badge bg--danger"><?php echo app('translator')->get("Stock Out"); ?></span>
                                    <?php endif; ?>
                                    <img src="<?php echo e(getImage(imagePath()['product']['path'].'/'.$deal->image,imagePath()['product']['size'])); ?>" alt="products">

                                    <div class="discount-wrapper">
                                        <div class="left">
                                            <p class="count"><?php echo e(getAmount($general->hot_deal_discount)); ?>% <?php echo app('translator')->get('Off'); ?></p>
                                        </div>
                                    </div>
                                </div>
                                <div class="content">
                                    <h6 class="product-name mt-3"><?php echo app('translator')->get($deal->name); ?></h6>

                                    <div class="price-wrapper">
                                        <div class="current-price"><?php echo e($general->cur_sym); ?><?php echo e(getAmount(afterDiscount($deal->price,$general->hot_deal_discount))); ?></div>
                                        <div class="past-price"><?php echo e($general->cur_sym); ?><?php echo e(getAmount($deal->price)); ?></div>
                                    </div>


                                    <div class="button-wrapper">
                                        <a href="<?php echo e(route('checkout',[$deal->slug,$deal->id])); ?>" class="cmn--btn btn--md bg--primary"><?php echo app('translator')->get('Order Now'); ?></a>
                                        <a href="<?php echo e(route('product.details',[$deal->id,$deal->slug])); ?>" class="cmn--btn btn--md bg--base"><?php echo app('translator')->get('View Details'); ?></a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
        </div>
    <?php endif; ?>
</div>


<?php
    $rows = getContent('overview.element', false, null, true);
?>

<section class="overview-section pt-50 pb-50">
    <div class="row justify-content-center g-4">
        <?php $__currentLoopData = $rows; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class ="col-lg-4 col-md-8 col-sm-10">
                <div class="overview-item h-100">

                    <div class="thumb">
                        <img src="<?php echo e(getImage('assets/images/frontend/overview/' .@$row->data_values->image, '128x128')); ?>" alt="icon">
                    </div>

                    <div class="content">
                        <h4 class="title"><?php echo e(__($row->data_values->heading)); ?></h4>
                        <p><?php echo e(__($row->data_values->sub_heading)); ?></p>
                    </div>

                </div>
            </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </div>
</section>

<?php $__env->stopSection(); ?>

<?php echo $__env->make($activeTemplate.'layouts.frontend', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/fkyiliss/evangel-ace.com.ng/core/resources/views/templates/basic/home.blade.php ENDPATH**/ ?>