<?php $__env->startSection('panel'); ?>

<div class="row">
    <div class="col-xl-12">
        <div class="card">
            <form action="<?php echo e(route('admin.product.add')); ?>" method="POST" enctype="multipart/form-data">
                <?php echo csrf_field(); ?>
                <div class="card-body">
                    <div class="row">
                        <div class="col-xl-4 col-lg-6">
                            <div class="form-group">
                                <label class="font-weight-bold"><?php echo app('translator')->get('Main Image'); ?> <span class="text--danger">*</span></label>
                                <div class="image-upload">
                                    <div class="thumb">
                                        <div class="avatar-preview">
                                            <div class="profilePicPreview" style="background-image: url(<?php echo e(getImage(imagePath()['product']['path'].'/',imagePath()['product']['size'])); ?>)">
                                                <button type="button" class="remove-image"><i class="fa fa-times"></i></button>
                                            </div>
                                        </div>
                                        <div class="avatar-edit">
                                            <input type="file" class="profilePicUpload" name="image" id="profilePicUpload1" accept=".png, .jpg, .jpeg" required>
                                            <label for="profilePicUpload1" class="bg--success"><?php echo app('translator')->get('Upload Image'); ?></label>
                                            <small class="mt-2 text-facebook"><?php echo app('translator')->get('Supported files'); ?>: <b><?php echo app('translator')->get('jpeg'); ?>, <?php echo app('translator')->get('jpg'); ?>, <?php echo app('translator')->get('png'); ?>.</b> <?php echo app('translator')->get('Image will be resized into 450x495'); ?> </small>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="col-xl-8 col-lg-6">

                            <div class="form-group">
                                <label class="font-weight-bold">
                                    <label for="name"><?php echo app('translator')->get('Product Name'); ?><span class="text--danger">*</span></label>
                                </label>
                                <input type="text" name="name" class="form-control" id="name" value="<?php echo e(old('name')); ?>" required>
                            </div>

                            <div class="row">
                                <div class="form-group col-xl-6">
                                    <label class="font-weight-bold">
                                        <?php echo app('translator')->get('Category'); ?> <span class="text-danger">*</span>
                                    </label>
                                    <div class="input-group">
                                        <select name="category" class="form-control select2-basic" required>
                                            <option value=""><?php echo app('translator')->get('Select One'); ?></option>
                                            <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($category->id); ?>"><?php echo e(__($category->name)); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>
                                </div>

                                <div class="form-group col-xl-6">
                                    <div class="input-group mb-3">
                                        <label class="font-weight-bold">
                                            <?php echo app('translator')->get('Brand'); ?> <span class="text-danger">*</span>
                                        </label>
                                        <select name="brand" class="form-control select2-basic" required>
                                            <option value=""><?php echo app('translator')->get('Select One'); ?></option>
                                            <?php $__currentLoopData = $brands; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $brand): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($brand->id); ?>"><?php echo e(__($brand->name)); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>
                                </div>

                                <div class="form-group col-xl-6">
                                    <label class="font-weight-bold">
                                        <?php echo app('translator')->get('Price'); ?> <span class="text-danger">*</span>
                                    </label>
                                    <div class="input-group">
                                        <div class="input-group-prepend">
                                            <div class="input-group-text"><?php echo e(__($general->cur_sym)); ?></div>
                                        </div>
                                        <input type="number" class="form-control" step="any" placeholder="0" name="price" value="<?php echo e(old('price')); ?>" required>
                                    </div>
                                </div>

                                <div class="form-group col-xl-6">
                                    <label class="font-weight-bold"><?php echo app('translator')->get('Discount'); ?></label>
                                    <div class="input-group">
                                        <input type="text" class="form-control" step="0.01" placeholder="0" name="discount" value="<?php echo e(old('discount')); ?>">
                                        <div class="input-group-append">
                                            <div class="input-group-text"><?php echo app('translator')->get('%'); ?></div>
                                        </div>
                                    </div>
                                </div>

                                <div class="form-group col-xl-6">
                                    <label class="font-weight-bold">
                                        <?php echo app('translator')->get('SKU'); ?> <span class="text-danger">*</span>
                                        <strong></strong>
                                    </label>
                                    <input type="text" class="form-control "  name="sku" value="<?php echo e(old('sku')); ?>" required>
                                </div>

                                <div class="form-group  col-xl-6">
                                    <label class="font-weight-bold"><?php echo app('translator')->get('Product Stock'); ?><span class="text--danger">*</span></label>
                                    <input type="number" name="stock" class="form-control" value="<?php echo e(old('stock')); ?>" required>
                                </div>

                                <div class="form-group col-xl-6">
                                    <label for="featured"><?php echo app('translator')->get('Featured'); ?></label>
                                    <input type="checkbox" data-width="100%" data-size="large" data-onstyle="-success" data-offstyle="-danger" data-toggle="toggle" id="featured" data-on="<?php echo app('translator')->get('Enable'); ?>" data-off="<?php echo app('translator')->get('Disable'); ?>" name="featured">
                                </div>

                                <div class="form-group col-xl-6">
                                    <label for="status"><?php echo app('translator')->get('Status'); ?></label>
                                    <input type="checkbox" data-width="100%" data-size="large" data-onstyle="-success" data-offstyle="-danger" data-toggle="toggle" id="status" data-on="<?php echo app('translator')->get('Enable'); ?>" data-off="<?php echo app('translator')->get('Disable'); ?>" name="status" checked>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="form-group">
                        <label class="font-weight-bold"><?php echo app('translator')->get('Description'); ?></label>
                        <textarea rows="15" class="form-control border-radius-5 nicEdit" name="description"><?php echo e(old('description')); ?></textarea>
                    </div>
                </div>
                <div class="card-footer">
                    <button type="submit" class="btn btn--primary btn-block"><?php echo app('translator')->get('Save'); ?></button>
                </div>
            </form>
        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>


<?php $__env->startPush('breadcrumb-plugins'); ?>
    <a href="<?php echo e(route('admin.product.index')); ?>" class="btn btn-sm btn--primary box--shadow1 text--small d-inline-flex justify-content-center align-items-center mt-2">
        <i class="la la-fw la-backward"></i><?php echo app('translator')->get('Go Back'); ?>
    </a>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/fkyiliss/evangel-ace.com.ng/core/resources/views/admin/product/add.blade.php ENDPATH**/ ?>