<?php
    $bgImage = getContent('auth.content', true);
?>

<?php $__env->startSection('content'); ?>
<!-- Account Section Starts Here -->
<section class="account-section bg_img d-flex" style="background: url(<?php echo e(getImage('assets/images/frontend/auth/' .@$bgImage->data_values->image, '1920x1280')); ?>) right;">
    <div class="account-wrapper">
        <div class="logo mb-4">
            <a href="<?php echo e(route('home')); ?>">
                <img src="<?php echo e(getImage(imagePath()['logoIcon']['path'] .'/logo.png')); ?>" alt="<?php echo app('translator')->get('logo'); ?>">
            </a>
        </div>
        <h3 class="title mb-5"><?php echo app('translator')->get('Login to your Account'); ?></h3>
        <form class="account-form" action="<?php echo e(route('user.login')); ?>" onsubmit="return submitUserForm();" method="post">
            <?php echo csrf_field(); ?>
            <div class="form--group">
                <input type="text" name="username" value="<?php echo e(old('username')); ?>" placeholder="<?php echo app('translator')->get('Username or Email'); ?>" class="form--control" required>
            </div>
            <div class="form--group">
                <input id="password" type="password" placeholder="<?php echo app('translator')->get('Password'); ?>" class="form--control" name="password" required >
            </div>

            <div class="form--group">
                <?php echo loadReCaptcha() ?>
            </div>

            <?php echo $__env->make($activeTemplate.'partials.custom_captcha', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

            <div class="row mb-2">

                <div class="col-xl-12 text-end">
                    <p><a class="text--base" href="<?php echo e(route('user.password.request')); ?>"><?php echo app('translator')->get('Forgot Password'); ?>?</a></p>
                </div>
            </div>
            <div class="form--group">
                <button type="submit" class="login"><?php echo app('translator')->get('Sign in'); ?></button>
            </div>
        </form>
       
    </div>
</section>
<!-- Account Section Ends Here -->

<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
    <script>
        "use strict";
        function submitUserForm() {
            var response = grecaptcha.getResponse();
            if (response.length == 0) {
                document.getElementById('g-recaptcha-error').innerHTML = '<span class="text-danger"><?php echo app('translator')->get("Captcha field is required."); ?></span>';
                return false;
            }
            return true;
        }
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make($activeTemplate.'layouts.auth_master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/fkyiliss/evangel-ace.com.ng/core/resources/views/templates/basic/user/auth/login.blade.php ENDPATH**/ ?>